package cn.com.duiba.quanyi.goods.service.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2023/8/9 10:54
 */
@Getter
@AllArgsConstructor
public enum OrderErrorCodeEnum {
    
    // G-商品库center错误码
    // 999-系统通用异常
    GC000000("成功"),
    GC999999("系统异常"),
    GC999001("参数错误"),
    GC999002("无权访问"),
    GC999003("操作过于频繁，请稍后再试"),
    
    // 商品
    GC000001("商品sku不存在或已删除"),
    GC000002("商品spu不存在或已删除"),
    GC000003("商品sku、spuId至少需要传入一个"),
    GC000004("商品类型异常"),
    GC000005("库存扣减失败"),
    GC000006("库存变更金额不能为空或为0"),
    GC000007("库存增加或减少失败"),
    GC000008("库存变更记录写入失败"),
    GC000009("库存扣减或回退失败"),
    
    
    // 订单相关
    GC001001("订单不存在"),
    GC001002("订单状态变更失败"),
    GC001003("订单状态异常"),
    GC001004("当前订单存在未结束的售后，禁止发货"),
    GC001005("订单状态变更记录写入失败"),
    GC001006("订单写入失败"),
    GC001007("该渠道不支持变更参数"),
    GC001008("变更是否扣减库存失败"),
    GC001009("实物不支持关闭订单，若不发货可以取消发货"),
    GC001010("该商品暂不支持"),
    
    // 供应商订单
    GC002001("供应商订单状态变更失败"),
    GC002002("供应商订单状态异常"),
    GC002003("供应商订单处理器不存在"),
    GC002004("供应商订单下单失败"),
    GC002005("供应商订单状态变更记录写入失败"),
    GC002006("订单已关闭，不支持再更改状态"),
    GC002007("当前订单状态不能关闭订单"),
    GC002008("子订单不存在，无法关闭"),
    GC002009("有多笔子订单，不支持关闭，请人工核实后，使用强制关闭功能"),
    ;
    private final String desc;
}
