package cn.com.duiba.quanyi.goods.service.api.param.car;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * 汽车服务-门店服务
 * @author kjj mybatis generator 
 * @date 2024-08-05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class CarSerStoreCodeSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 上页最后一个id
     */
    private Long lastId;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 省
     */
    private String storeProvince;

    /**
     * 市
     */
    private String storeCity;

    /**
     * 区
     */
    private String storeDistrict;

    /**
     * 省-行政区划编码
     */
    private String provinceCode;

    /**
     * 市-行政区划编码
     */
    private String cityCode;

    /**
     * 区-行政区划编码
     */
    private String districtCode;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 维度
     */
    private String latitude;

    /**
     * 服务名
     */
    private String serName;

    /**
     * 唯一服务编码
     */
    private List<String> unionCodes;

    /**
     * 删除标记
     */
    private Integer logicDelete;

    /**
     * 门店id
     */
    private String storeId;

    /**
     * 平台类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.car.CarSerPlatformTypeEnum
     */
    private Integer platformType;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 兑吧服务编码
     */
    private String dbCode;

    /**
     * 平台服务编码
     */
    private String platformCode;

    /**
     * 唯一服务编码
     */
    private String unionCode;

}