package cn.com.duiba.quanyi.goods.service.api.dto.supplier;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 供应商账户表
 * @author kjj mybatis generator 
 * @date 2024-03-22
 */
@Data
public class SupplierAccountDto implements Serializable {
     
    private static final long serialVersionUID = 17110765809652473L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.goods.service.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 账号
     */
    private String accountNo;

    /**
     * 添加人ID
     */
    private Long addOperatorId;

    /**
     * 添加人姓名
     */
    private String addOperatorName;

    /**
     * 添加时间
     */
    private Date addTime;

    /**
     * 删除人ID
     */
    private Long delOperatorId;

    /**
     * 删除人姓名
     */
    private String delOperatorName;

    /**
     * 删除时间
     */
    private Date delTime;
}