package cn.com.duiba.quanyi.goods.service.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * sku配置拓展表
 *
 * @author kjj mybatis generator
 * @date 2023-11-22
 */
@AdvancedFeignClient
public interface RemoteSkuExtService {

    /**
     * 根据skuId批量查询
     *
     * @param skuIds skuId列表
     * @return key：配置key，value：配置值
     */
    Map<Long, Map<Integer, String>> selectMapBySkuIds(List<Long> skuIds);

    /**
     * 根据skuId查询
     *
     * @param skuId skuId
     * @return key：配置key，value：配置值
     */
    Map<Integer, String> selectMapBySkuId(Long skuId);

    /**
     * 根据sku和配置名称批量查询
     *
     * @param skuIds skuId列表
     * @param confName 配置名称
     * @return key：skuId，value：配置值
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SkuExtConfNameEnum
     */
    Map<Long, String> selectMapBySkuIdsConf(Set<Long> skuIds, Integer confName);

    /**
     * 根据sku和配置名称查询
     *
     * @param skuId    skuId
     * @param confName 配置名称
     * @return 配置值
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SkuExtConfNameEnum
     */
    String selectBySkuConf(Long skuId, Integer confName);


}