package cn.com.duiba.quanyi.goods.service.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2023/8/9 10:54
 */
@Getter
@AllArgsConstructor
public enum OrderErrorCodeEnum {
    
    // G-商品库center错误码
    // 999-系统通用异常
    GC000000("成功"),
    GC999999("系统异常"),
    GC999001("参数错误"),
    GC999002("无权访问"),
    GC999003("操作过于频繁，请稍后再试"),
    
    // 商品
    GC000001("商品sku不存在或已删除"),
    GC000002("商品spu不存在或已删除"),
    GC000003("商品sku、spuId至少需要传入一个"),
    GC000004("商品类型异常"),
    
    // 订单相关
    GC001001("订单不存在"),
    GC001002("订单状态变更失败"),
    GC001003("订单状态异常"),
    GC001004("当前订单存在未结束的售后，禁止发货"),
    GC001005("订单状态变更记录写入失败"),
    GC001006("订单写入失败"),
    
    // 供应商订单
    GC002001("供应商订单状态变更失败"),
    GC002002("供应商订单状态异常"),
    GC002003("供应商订单处理器不存在"),
    GC002004("供应商订单下单失败"),
    ;
    private final String desc;
}
