/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.goods.service.api.enums.goods;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PurchaseSpuTypeEnum {
    OBJECT(1, "\u5b9e\u7269"),
    MOBILE_PAYMENT(2, "\u5feb\u6377\u652f\u4ed8"),
    ZC(3, "\u76f4\u5145"),
    KA_MI(4, "\u5361\u5bc6"),
    CAR_SER(5, "\u6c7d\u8f66\u670d\u52a1"),
    ADVANCE_PAYMENT(6, "\u57ab\u8d44");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, PurchaseSpuTypeEnum> ENUM_MAP;

    public static PurchaseSpuTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    private PurchaseSpuTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(PurchaseSpuTypeEnum.values()).collect(Collectors.toMap(PurchaseSpuTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    }
}

