package cn.com.duiba.quanyi.goods.service.api.dto.goods;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 采购商品SKU表
 * @author kjj mybatis generator 
 * @date 2024-10-24
 */
@Data
public class PurchaseSkuDto implements Serializable {
     
    private static final long serialVersionUID = 17297522632738879L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否已删除：0-未删除，1-已删除
     */
    private Integer logicDelete;

    /**
     * 采购商品SPU id
     */
    private Long purchaseSpuId;

    /**
     * 供货价，单位分，比如1元，数据存为100
     */
    private Integer supplyPrice;

    /**
     * 指导价，划线价，单位分，比如1元，数据存为100
     */
    private Integer marketPrice;

    /**
     * 建议售价，平台卖价，单位分，比如1元，数据存为100
     */
    private Integer sellPrice;

    /**
     * 结算费率，百分数，支持小数点
     */
    private String settlementRate;

    /**
     * SKU优先级最高的图
     */
    private String purchaseSkuImg;

    /**
     * 规格配置 json
     */
    private String attrConf;

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * sku状态
     */
    private Integer purchaseSkuStatus;
}