package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.sinopec.SinopecOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.sinopec.SinopecOrderResult;

/**
 * 订单-中石化
 *
 * @author wangguanhua
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorSinopecService {

    /**
     * 下单
     *
     * @param dto 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<SinopecOrderCreateReq> dto);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    SinopecOrderResult findOrderResult(String customerOrderNo);
}
