package cn.com.duiba.quanyi.goods.service.api.dto.car;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * 汽车服务-门店服务编码
 * @author kjj mybatis generator 
 * @date 2024-08-05
 */
@Data
@ToString(callSuper = true)
public class CarSerStoreEsDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 省
     */
    private String storeProvince;

    /**
     * 市
     */
    private String storeCity;

    /**
     * 区
     */
    private String storeDistrict;

    /**
     * 详细地址
     */
    private String storeAddress;

    /**
     * 省-行政区划编码
     */
    private String provinceCode;

    /**
     * 市-行政区划编码
     */
    private String cityCode;

    /**
     * 区-行政区划编码
     */
    private String districtCode;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 维度
     */
    private String latitude;

    /**
     * 门店图片
     */
    private String storeImg;

    /**
     * 明细图片，英文逗号分隔
     */
    private String descImg;

    /**
     * 营业时间，格式：HH:mm-HH:mm
     */
    private String businessTime;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.goods.service.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 门店服务编码列表
     */
    private List<CarSerStoreCodeEsDto> serviceCodeList;

    /**
     * 门店服务codelist集合
     */
    private List<String> unionCodes;

    /**
     * 距离
     */
    private String sort;
}