package cn.com.duiba.quanyi.goods.service.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.SupplierSpuRefDto;
import cn.com.duiba.quanyi.goods.service.api.param.goods.SupplierSpuRefSearchParam;
import java.util.List;

/**
 * 供应商费率和spu
 * @author kjj mybatis generator 
 * @date 2024-10-26
 */
@AdvancedFeignClient
public interface RemoteSupplierSpuRefService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 供应商费率和spu集合
     */
    List<SupplierSpuRefDto> selectPage(SupplierSpuRefSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SupplierSpuRefSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 供应商费率和spu
     */
    SupplierSpuRefDto selectById(Long id);

    /**
     * 根据spuId查询
     * @param purchaseSpuId 查询条件
     * @return 供应商费率和spu集合
     */
    List<SupplierSpuRefDto> selectByPurchaseSpuId(Long purchaseSpuId);

    /**
     * 根据spuId集合查询
     * @param purchaseSpuIds
     * @return
     */
    List<SupplierSpuRefDto> selectByPurchaseSpuIds(List<Long> purchaseSpuIds);

    /**
     * 新增
     * @param dto 供应商费率和spu
     * @return 影响行数
     */
    int insert(SupplierSpuRefDto dto);

    /**
     * 更新
     * @param dto 供应商费率和spu
     * @return 影响行数
     */
    int update(SupplierSpuRefDto dto);

    /**
     * 批量插入或者更新
     * @param list
     * @return
     */

    int batchInsertOrUpdate( List<SupplierSpuRefDto> list);
}