package cn.com.duiba.quanyi.goods.service.api.dto.goods;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * SKU表
 *
 * @author kjj mybatis generator
 * @date 2023-11-22
 */
@Data
public class SkuDto implements Serializable {

    private static final long serialVersionUID = 17006196619513479L;

    /**
     * 主键
     */
    private Long id;

    /**
     * SPU id
     */
    private Long spuId;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 供货价，单位分，比如1元，数据存为100
     */
    private Integer supplyPrice;

    /**
     * 指导价，划线价，单位分，比如1元，数据存为100
     */
    private Integer marketPrice;

    /**
     * 建议售价，平台卖价，单位分，比如1元，数据存为100
     */
    private Integer sellPrice;

    /**
     * SKU优先级最高的图
     */
    private String skuImg;

    /**
     * 规格配置 json
     */
    private List<AttrValueDto> attrConf;

    /**
     * 是否已删除：0-未删除，1-已删除
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.LogicDeleteEnum#getCode()
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * 供应商spuid
     */
    private Long purchaseSpuId;

    /**
     * 供应商skuid
     */
    private Long purchaseSkuId;

}