package cn.com.duiba.quanyi.goods.service.api.remoteservice.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.supplier.SupplierSpuTypeRefDto;

import java.util.List;

/**
 * 供应商商品类型关联表
 *
 * @author kjj mybatis generator
 * @date 2023-11-28
 */
@AdvancedFeignClient
public interface RemoteSupplierSpuTypeRefService {

    /**
     * 根据主键查询，包含已删除的
     *
     * @param id 主键
     * @return 供应商商品类型关联
     */
    SupplierSpuTypeRefDto selectById(Long id);

    /**
     * 根据商品类型查询响应的供应商，不包含已删除的
     *
     * @param spuType 商品类型
     * @return 供应商主键ID
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    List<Long> selectSupplierIdsBySpuType(Integer spuType);

    /**
     * 通过商品类型批量查询
     * @param spuTypeList
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @return
     */
    List<Long> selectSupplierIdsBySpuTypeList(List<Integer> spuTypeList);

    /**
     * 根据唯一约束查询，包含已删除的
     *
     * @param supplierId 供应商ID
     * @param spuType    spu类型
     * @return api code
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    SupplierSpuTypeRefDto selectByUk(Long supplierId, Integer spuType);

    /**
     * 查询供应商支持的商品类型，不包含已删除的
     *
     * @param supplierId 供应商ID
     * @return api code
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    List<SupplierSpuTypeRefDto> selectBySupplierId(Long supplierId);

    /**
     * 新增
     *
     * @param dto 供应商商品类型关联
     * @return 主键
     */
    Long insert(SupplierSpuTypeRefDto dto);

    /**
     * 更新
     *
     * @param dto 供应商商品类型关联
     * @return 影响行数
     */
    int update(SupplierSpuTypeRefDto dto);

    /**
     * 软删
     *
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}