package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretBatchDto;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretCouponDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretBatchQueryParam;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretBindDemandGoodsParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Set;

/**
 * CardSecretRemoteService
 * @author fumingkun
 */
@AdvancedFeignClient
public interface RemoteCardSecretBatchService {

    /**
     * 如果批次已经过期了, 则异步将未使用的券码加载到redis
     *
     * @param cardSecretBatchId 卡密批次ID
     * @return 是否触发了加载
     */
    boolean asyncLoadNotUseToRedisIfExpiration(Long cardSecretBatchId);

    /**
     * 批量保存并返回之前存在的值
     *
     * @param list         需要保存的entity
     * @param cardSecretBatchId 卡密批次ID
     * @return left:是否成功, right:已经存在的券码唯一标记
     */
    Pair<Boolean, Set<String>> batchAddCouponAndGetExistCoupon(Long cardSecretBatchId, List<CardSecretCouponDto> list);

    /**
     * 批量保存并返回
     *
     * @param list              需要保存的entity
     * @param cardSecretBatchId 卡密批次ID
     * @return left:是否成功, right:已经存在的券码唯一标记
     */
    Pair<Boolean, Set<String>> batchAddCoupon(Long cardSecretBatchId, List<CardSecretCouponDto> list);

    /**
     * 更新
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    int update(CardSecretBatchDto dto);

    /**
     * 保存
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    Long insert(CardSecretBatchDto dto);

    /**
     * 根据主键ID查询
     *
     * @param id 主键ID
     * @return CardSecretDto
     */
    CardSecretBatchDto selectById(Long id);

    /**
     * 删除
     *
     * @param id 主键ID
     * @return 影响行数
     */
    int delete(Long id);

    /**
     * 统计行数
     *
     * @param queryParam 查询参数
     * @return 行数
     */
    long selectCount(CardSecretBatchQueryParam queryParam);

    /**
     * 分页查询
     *
     * @param queryParam 查询参数
     * @return A List Of CardSecretDto
     */
    List<CardSecretBatchDto> selectPage(CardSecretBatchQueryParam queryParam);

    /**
     * 根据ids查询
     *
     * @param ids ids
     * @return A List Of CardSecretDto
     */
    List<CardSecretBatchDto> selectByIdList(Set<Long> ids);

    /**
     * 根据需求商品ID查询
     *
     * @param demandGoodId 需求商品ID
     * @return A List Of CardSecretDto
     */
    List<CardSecretBatchDto> findByDemandGoodsId(Long demandGoodId);

    /**
     * 根据需求商品ID批量查询
     *
     * @param demandGoodIds 需求商品ID列表
     * @return 卡密批次列表
     */
    List<CardSecretBatchDto> selectByDemandGoodIds(Set<Long> demandGoodIds);

    /**
     * 批量绑定需求商品
     *
     * @param goodsParamList 需要绑定的集合
     * @return 影响行数
     */
    int batchBindDemandGoods(List<CardSecretBindDemandGoodsParam> goodsParamList);

    /**
     * 批量取消绑定需求商品
     *
     * @param unBindList   需要取消绑定的ID集合
     * @param demandGoodId 需求商品ID
     * @return 影响行数
     */
    int batchUnbindDemandGoods(List<Long> unBindList, Long demandGoodId);

    /**
     * 批量取消绑定需求商品
     *
     * @param ids 需要取消绑定的ID集合
     * @param demandId 需求ID
     * @return 影响行数
     */
    int batchUnbindByDemand(List<Long> ids, Long demandId);

    /**
     * 根据需求ID和SKU查询
     *
     * @param demandId 需求ID
     * @param skuId    SKU ID
     * @return A List Of CardSecretDto
     */
    List<CardSecretBatchDto> selectByDemandSkuId(Long demandId, Long skuId);

    /**
     * 根据需求ID查询
     * @param demandId 需求ID
     * @return 批次
     */
    List<CardSecretBatchDto> selectByDemandId(Long demandId);

    /**
     * 根据需求ID和SKU查询
     *
     * @param demandGoodsId 需求商品id
     * @param skuId    SKU ID
     * @return A List Of CardSecretEntity
     */
    List<CardSecretBatchDto> selectByDemandGoodsIdSkuId(Long demandGoodsId, Long skuId);

    /**
     * 根据id查询(忽略删除)
     *
     * @param cardSecretBatchId 批次号ID
     * @return CardSecretBatchDto
     */
    CardSecretBatchDto selectByIdIgnoreDelete(Long cardSecretBatchId);


    /**
     * 根据采购商品ID查询
     * @param purchaseSpuIds 采购商品ID集合
     * @return 批次集合
     */
    List<CardSecretBatchDto> selectByPurchaseSpuIds(Set<Long> purchaseSpuIds);

}
