package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.keepvip.KeepVipZcOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.xunleivip.XunLeiVipZcOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.keepvip.KeepVipZcOrderResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.xunleivip.XunLeiVipZcOrderResult;

/**
 * RemoteOrderProcessorKeepVipService
 *
 * @author xuzhigang
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorKeepVipService {

    /**
     * 下单
     *
     * @param req 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<KeepVipZcOrderCreateReq> req);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    KeepVipZcOrderResult findOrderResult(String customerOrderNo);

}
