package cn.com.duiba.quanyi.goods.service.api.enums.subject;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: LuHui
 * @date: 2024/8/8 17:20
 * @description:
 */
@RequiredArgsConstructor
@Getter
public enum SubjectEnum {

    DUI_BA(1, "杭州兑吧网络科技有限公司", "杭州兑吧"),
    DUI_A(2, "杭州兑啊网络科技有限公司", "杭州兑啊"),
    DUI_JIE(3, "兑捷", "兑捷"),
    FJ_DUI_TUI(4, "福建兑推网络科技有限公司", "福建兑推"),
    AH_CHUAN_SI(5, "安徽汌思信息科技有限公司", "安徽汌思"),
    AH_ZHI_YU(6, "安徽知予网络科技有限公司", "安徽知予"),
    SD_DUI_TUI(7, "山东兑推网络科技有限公司", "山东兑推"),
    FJ_DUI_BA(8, "福建兑吧网络科技有限公司", "福建兑吧"),
    AH_DUI_BA(9, "安徽兑吧网络科技有限公司", "安徽兑吧"),
    DUIBA_TONG_LING(10, "杭州兑吧网络科技有限公司铜陵分公司", "铜陵分公司"),
    FJ_DUI_A(11, "福建兑啊网络科技有限公司", "福建兑啊"),
    HZ_MEI_REN(12, "杭州美韧网络科技有限公司", "杭州美韧"),
    HZ_SHEN_TONG(13, "杭州神同网络科技有限公司", "杭州神同"),
    SC_KE_JIE(14, "四川客捷网络科技有限公司", "四川客捷"),
    WH_HOU_AN(15, "武汉厚安网络科技有限公司", "武汉厚安"),
    QD_JI_LIANG(16, "青岛集量网络科技有限公司", "青岛集量"),
    HN_DUI_BA(17, "湖南兑吧网络科技有限公司", "湖南兑吧"),
    HZ_MAI_YAN(18, "杭州麦严网络科技有限公司", "杭州麦严"),
    SH_KA_YI_DE(19, "上海卡易得网络科技有限公司", "上海卡易得"),
    DUI_BA_FU_JIAN(20, "杭州兑吧网络科技有限公司福建分公司", "福建分公司"),
    DUI_BA_MU_YANG(21, "杭州兑吧网络科技有限公司沭阳分公司", "沭阳分公司"),
    JS_DUI_A(22, "江苏兑啊网络科技有限公司", "江苏兑啊"),
    MAI_QUAN(23, "麦全网络科技有限公司", "麦全"),
    MAI_YAN(24, "麦严网络科技有限公司", "麦严"),
    SHEN_TONG(25, "神同网络科技有限公司", "神同"),
    MEI_REN(26, "美韧网络科技有限公司", "美韧"),
    KE_JI_JI(27, "客吉吉网络科技有限公司", "客吉吉"),
    CQ_DUI_BA(28, "重庆兑吧网络科技有限公司", "重庆兑吧"),
    MAI_YOU_GOU(29, "麦优购网络科技有限公司", "麦优购"),
    JS_DUI_BA(30, "江苏兑吧网络科技有限公司", "江苏兑吧"),
    GZ_YUE_BA(31, "广州粤吧网络科技有限公司", "广州粤吧"),
    GZ_DUI_BA(32, "广州兑吧网络科技有限公司", "广州兑吧"),
    CD_XIN_YUN(33, "成都欣韵网络有限公司", "成都欣韵"),

    ;


    private final Integer type;

    private final String desc;
    
    private final String abbreviation;

    private static final Map<Integer, SubjectEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SubjectEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     *
     * @param type 枚举值
     * @return 枚举
     */
    public static SubjectEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 根据枚举的简称获取枚举
     */
    public static SubjectEnum getByAbbreviation(String abbreviation) {
        if (abbreviation == null) {
            return null;
        }
        return Arrays.stream(values()).filter(e -> e.getAbbreviation().equals(abbreviation)).findFirst().orElse(null);
    }
    /**
     * 根据枚举的描述获取枚举
     */
    public static SubjectEnum getByDesc(String desc) {
        if (desc == null) {
            return null;
        }
        return Arrays.stream(values()).filter(e -> e.getDesc().equals(desc)).findFirst().orElse(null);
    }

    /**
     * 根据枚举的简称或者描述获取枚举
     */
    public static SubjectEnum getByAbbreviationOrDesc(String abbreviationOrDesc) {
        if (abbreviationOrDesc == null) {
            return null;
        }
        return Arrays.stream(values()).filter(e -> e.getAbbreviation().equals(abbreviationOrDesc) || e.getDesc().equals(abbreviationOrDesc)).findFirst().orElse(null);
    }

}
