package cn.com.duiba.quanyi.goods.service.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * sku扩展信息配置名称
 *
 * @author lizhi
 * @date 2023/9/20 16:15
 */
@Getter
@AllArgsConstructor
public enum SkuExtConfNameEnum {
    I_QI_YI_ITEM(1, "爱奇艺item"),
    MEI_TUAN_STORE_ITEM(2, "美团到店item"),
    YOU_KU_ITEM(3, "优酷item"),
    JI_GAO_VOICE_FLAG(4, "继皋是否有发票：0无票、1专票、2零票，默认为1"),
    TE_ZHEN_PRODUCT_TYPE(6, "特祯-产品类型"),
    TE_ZHEN_PACKAGE_SIZE(7, "特祯-包体类型"),
    CHONG_DA_AMOUNT(5, "充达无票话费面值"),
    KA_CHI_INFO_MSG(8, "卡池批次号"),
    AMOUNT_MAX_LIMIT(9, "单笔最高限额"),
    MONTH_AMOUNT_LIMIT(10, "单月限额"),
    AMOUNT_MIN_LIMIT(11, "单笔最低金额"),
    MULTI_SUPPLIER_WX_TRANSFER(12, "多供应商微信零钱"),
    MULTI_SUPPLIER_WX_TRANSFER_CONF_JSON(13, "多供应商微信零钱-对应配置json"),
    DIAN_DIAN_PRICE(14, "点点-面值"),
    BA_WANG_CHA_JI_ACTIVITY_ID(15, "霸王茶姬活动id"),
    BA_WANG_CHA_JI_CHANNEL_ID(16, "霸王茶姬渠道id"),
    DIAN_DIAN_QUANTITY(22, "点点-充值件数"),
    YI_PAI_QUANTITY(23, "易派-充值件数"),
    MCH_ID(24, "商户号"),
    KA_CHI_PRODUCT_CODE_MAP(25, "卡池话费产品编码映射"),
    HONG_EN_PRICE(26, "洪恩商品价格"),
    CAR_SER_DB_CODE(27, "汽车服务-兑吧编码"),
    SHUN_YI_CHONG_BATCH_NO(28, "顺易充批次号"),
    SHUN_YI_CHONG_COUPON_NO(29, "顺易充优惠券编码"),
    SHUN_YI_CHONG_COUPON_NUM(30, "顺易充优惠券数量"),
    SHUN_YI_CHONG_RECHARGE_CARD_ID(31, "顺易充充电卡ID"),
    SHUN_YI_CHONG_RECHARGE_CARD_NO(32, "顺易充充电卡卡号"),
    SHUN_YI_CHONG_EFFECT_TIME(33, "顺易充有效期"),
    SHUN_YI_CHONG_RECHARGE_CARD_AMT(34, "顺易充充电卡金额"),
    ;

    private final Integer name;

    private final String desc;
}
