package cn.com.duiba.quanyi.goods.service.api.dto.cardsecret;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 卡密表
 *
 * @author kjj mybatis generator
 * @date 2023-11-21
 */
@Data
public class CardSecretCouponDto implements Serializable {

    private static final long serialVersionUID = 17005479268433226L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 卡密批次号ID,tb_card_secret_batch.id
     */
    private Long cardSecretBatchId;

    /**
     * 商品ID
     */
    private Long spuId;

    /**
     * 卡密类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.CardSecretTypeEnum
     */
    private Integer cardSecretType;

    /**
     * 上传任务ID
     */
    private Long taskId;

    /**
     * 劵码
     */
    private String couponCode;

    /**
     * 链接劵
     */
    private String linkCode;

    /**
     * 账号
     */
    private String accountNo;

    /**
     * 密码
     */
    private String accountPassword;

    /**
     * 发放状态 0-未发放 1-已发放
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum
     */
    private Integer couponStatus;

    /**
     * 发放时间
     */
    private Date grantTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 采购单ID
     */
    private Long purchaseOrderId;

    /**
     * 入库单ID
     */
    private Long inboundOrderId;

    /**
     * 关联过的批次ID，以英文逗号分隔
     */
    private String cardSecretBatchIds;
}