package cn.com.duiba.quanyi.goods.service.api.param.cardsecret;

import java.util.Date;
import java.util.List;

import javax.annotation.Nullable;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 卡密关联记录查询参数
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CardSecretAssociationTaskQueryParam extends PageQuery {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 采购单ID
     */
    private Long purchaseOrderId;

    /**
     * 创建人ID
     */
    private Long creatorId;

    /**
     * 生成的批次ID
     */
    private Long cardSecretBatchId;

    /**
     * 关联的需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 交付形式
     * @see cn.com.duiba.quanyi.goods.service.api.enums.cardsecret.DeliveryMethodEnum
     */
    private Integer deliveryMethod;

    /**
     * 状态
     * @see cn.com.duiba.quanyi.goods.service.api.enums.cardsecret.AssociationTaskStatusEnum
     */
    private Integer status;

    /**
     * 创建时间-开始
     */
    @Nullable
    private Date createTimeStart;

    /**
     * 创建时间-结束
     */
    @Nullable
    private Date createTimeEnd;

    /**
     * 采购单ID列表
     */
    private List<Long> purchaseOrderIds;

    /**
     * 批次ID列表
     */
    private List<Long> cardSecretBatchIds;

    /**
     * 需求商品ID列表
     */
    private List<Long> demandGoodsIds;

    /**
     * 状态列表
     */
    private List<Integer> statusList;

}
