package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.supplier.SupplierOrderWxCouponDto;

import java.util.List;

/**
 * 供应商订单-微信立减金扩展字段
 *
 * @author kjj mybatis generator
 * @date 2023-11-28
 */
@AdvancedFeignClient
public interface RemoteSupplierOrderWxCouponService {


    /**
     * 计算非固定金额批次已发放金额，注意该方法仅开给运营postman调用，其他业务勿用
     * @param stockId 批次号
     * @return 已发放总金额
     */
    Long sumUnFixedStockAmount(String stockId);


    /**
     * 根据订单号批量查询
     *
     * @param orderNoList 订单号集合
     * @return 供应商订单-微信立减金扩展字段
     */
    List<SupplierOrderWxCouponDto> selectByOrderNoList(List<String> orderNoList);
}