package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretInboundBatchDto;

/**
 * 卡密入库批次远程服务
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@AdvancedFeignClient
public interface RemoteCardSecretInboundBatchService {

    /**
     * 更新卡密入库批次
     *
     * @param dto 卡密入库批次DTO
     * @return 更新数量
     */
    int update(CardSecretInboundBatchDto dto);

    /**
     * 插入卡密入库批次
     *
     * @param dto 卡密入库批次DTO
     * @return 主键ID
     */
    Long insert(CardSecretInboundBatchDto dto);

    /**
     * 根据ID查询卡密入库批次
     *
     * @param id 主键ID
     * @return 卡密入库批次DTO
     */
    CardSecretInboundBatchDto selectById(Long id);

    /**
     * 根据ID删除卡密入库批次
     *
     * @param id 主键ID
     * @return 删除数量
     */
    int delete(Long id);

    /**
     * 根据采购单ID查询卡密入库批次列表
     *
     * @param purchaseOrderId 采购单ID
     * @return 卡密入库批次列表
     */
    List<CardSecretInboundBatchDto> selectByPurchaseOrderId(Long purchaseOrderId);

    /**
     * 根据入库单ID查询卡密入库批次列表
     *
     * @param inboundOrderId 入库单ID
     * @return 卡密入库批次列表
     */
    List<CardSecretInboundBatchDto> selectByInboundOrderId(Long inboundOrderId);

    /**
     * 根据批次ID查询卡密入库批次列表
     *
     * @param cardSecretBatchId 批次ID
     * @return 卡密入库批次列表
     */
    List<CardSecretInboundBatchDto> selectByCardSecretBatchId(Long cardSecretBatchId);
}

