package cn.com.duiba.quanyi.goods.service.api.enums.cardsecret;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 交付形式枚举
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Getter
@AllArgsConstructor
public enum DeliveryMethodEnum {
    ONLINE(1, "线上交付"),
    OFFLINE(2, "线下交付"),
    EMAIL(3, "邮件交付"),
    ;

    private final Integer code;
    private final String desc;

    public static DeliveryMethodEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (DeliveryMethodEnum methodEnum : values()) {
            if (methodEnum.getCode().equals(code)) {
                return methodEnum;
            }
        }
        return null;
    }
}
