package cn.com.duiba.quanyi.goods.service.api.dto.cardsecret;

import java.io.Serializable;

import lombok.Data;

/**
 * 卡密批次ES DTO
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Data
public class CardSecretBatchEsDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 采购单ID
     */
    private Long id;

    /**
     * 商品id
     */
    private Long spuId;

    /**
     * 卡密类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.CardSecretTypeEnum
     */
    private Integer cardSecretType;

    /**
     * 生效时间（时间戳）
     */
    private Long effectiveTime;

    /**
     * 失效时间（时间戳）
     */
    private Long expirationTime;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购商品主键, tb_purchase_goods.id
     */
    private Long demandGoodsId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建人ID
     */
    private Long creatorId;

    /**
     * 创建人姓名
     */
    private String creatorName;

    /**
     * 创建时间（时间戳）
     */
    private Long gmtCreate;

    /**
     * 更新时间（时间戳）
     */
    private Long gmtModified;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * tb_purchase_spu.id
     */
    private Long purchaseSpuId;

    /**
     * tb_purchase_sku.id
     */
    private Long purchaseSkuId;

    /**
     * 卡密说明
     */
    private String cardSecretDesc;

    /**
     * 费率
     */
    private String costRate;

    /**
     * 成本价
     */
    private Integer costPrice;

    /**
     * 是否重复
     */
    private Integer cardSecretRepeat;

    /**
     * 卡密面额
     */
    private Integer cardDenomination;

    /**
     * 批次类型，1-旧批次，2-线上批次，3-线下批次，4-采购单
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.BatchTypeEnum
     */
    private Integer batchType;

    /**
     * 商品名称（用于搜索）
     */
    private String goodsName;

    /**
     * 是否结算：0-不结算，1-结算
     */
    private Integer isSettled;

    /**
     * 入库状态：1-未入库，2-部分入库，3-已入库
     */
    private Integer receivingStatus;

    /**
     * 备注
     */
    private String remark;

    /**
     * 采购数量
     */
    private Long purchaseQty;

    /**
     * 分配数量
     */
    private Long allocatedQty;

    /**
     * 已入库数量
     */
    private Long receivedQty;

    /**
     * 发起关联数量
     */
    private Long toLinkQty;

    /**
     * 已关联数量
     */
    private Long linkedQty;

}
