package cn.com.duiba.quanyi.goods.service.api.remoteservice.car;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.car.CarSerDbCodeDto;
import cn.com.duiba.quanyi.goods.service.api.param.car.CarSerDbCodeSearchParam;
import java.util.List;

/**
 * 汽车服务-兑吧服务编码
 * @author kjj mybatis generator 
 * @date 2024-08-11
 */
@AdvancedFeignClient
public interface RemoteCarSerDbCodeService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 汽车服务-兑吧服务编码集合
     */
    List<CarSerDbCodeDto> selectPage(CarSerDbCodeSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CarSerDbCodeSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 汽车服务-兑吧服务编码
     */
    CarSerDbCodeDto selectById(Long id);

    /**
     * 新增
     * @param dto 汽车服务-兑吧服务编码
     * @return 影响行数
     */
    int insert(CarSerDbCodeDto dto);

    /**
     * 更新
     * @param dto 汽车服务-兑吧服务编码
     * @return 影响行数
     */
    int update(CarSerDbCodeDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}