package cn.com.duiba.quanyi.goods.service.api.remoteservice.car;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.car.CarSerStoreCodeDto;
import cn.com.duiba.quanyi.goods.service.api.dto.car.CarSerStoreEsDto;
import cn.com.duiba.quanyi.goods.service.api.param.car.CarSerStoreCodeSearchParam;

import java.util.List;

/**
 * 汽车服务-门店服务编码
 * @author kjj mybatis generator 
 * @date 2024-08-05
 */
@AdvancedFeignClient
public interface RemoteCarSerStoreCodeService {

    /**
     * 门店服务查询
     * @param param
     * @return
     */
    List<CarSerStoreEsDto> selectPage(CarSerStoreCodeSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 汽车服务-门店服务编码
     */
    CarSerStoreCodeDto selectById(Long id);


    /**
     * 根据门店id查询
     * @param id
     * @return
     */
    CarSerStoreEsDto selectEsByStoreId(Long id);
}