package cn.com.duiba.quanyi.goods.service.api.enums.express;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物流状态（0在途，1揽收，2疑难，3签收，4退签，5派件，6退回，7转投）
 *
 * @author wangguanhua
 */
@Getter
@AllArgsConstructor
public enum ExpressTrackStatusEnum {

    NO_INFO(-1, "暂无物流轨迹信息"),
    IN_TRANSIT(0, "在途"),
    PICK_UP(1, "揽收"),
    DIFFICULT(2, "疑难"),
    RECEIVED(3, "签收"),
    SIGN_OUT(4, "退签"),
    DELIVERY(5, "派件"),
    REFUND(6, "退回"),
    SWITCH(7, "转投"),
    ;

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, ExpressTrackStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ExpressTrackStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    /**
     * get by status
     *
     * @param status status
     * @return {@link ExpressTrackStatusEnum }
     */
    public static ExpressTrackStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

}
