package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import java.util.List;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretAssociationTaskDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretAssociationTaskQueryParam;

/**
 * 卡密关联记录远程服务
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@AdvancedFeignClient
public interface RemoteCardSecretAssociationTaskService {


    /**
     * 保存
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    Long insert(CardSecretAssociationTaskDto dto);

    /**
     * 根据主键ID查询
     *
     * @param id 主键ID
     * @return CardSecretAssociationTaskDto
     */
    CardSecretAssociationTaskDto selectById(Long id);


    /**
     * 根据采购单ID查询
     *
     * @param purchaseOrderId 采购单ID
     * @return 关联记录列表
     */
    List<CardSecretAssociationTaskDto> selectByPurchaseOrderId(Long purchaseOrderId);

    /**
     * 根据批次ID查询
     *
     * @param cardSecretBatchId 批次ID
     * @return 关联记录列表
     */
    List<CardSecretAssociationTaskDto> selectByCardSecretBatchId(Long cardSecretBatchId);

    /**
     * 根据需求商品ID查询
     *
     * @param demandGoodsId 需求商品ID
     * @return 关联记录列表
     */
    List<CardSecretAssociationTaskDto> selectByDemandGoodsId(Long demandGoodsId);

    /**
     * 根据状态查询
     *
     * @param status 状态
     * @return 关联记录列表
     */
    List<CardSecretAssociationTaskDto> selectByStatus(Integer status);

    /**
     * 统计行数
     *
     * @param queryParam 查询参数
     * @return 行数
     */
    long selectCount(CardSecretAssociationTaskQueryParam queryParam);

    /**
     * 分页查询
     *
     * @param queryParam 查询参数
     * @return 关联记录列表
     */
    List<CardSecretAssociationTaskDto> selectPage(CardSecretAssociationTaskQueryParam queryParam);

    /**
     * 根据关联任务ID重试
     *
     * @param associationTaskId 关联任务ID
     * @return 影响行数
     */
    Integer retryAssociationTask(Long associationTaskId) throws BizException;
}

