package cn.com.duiba.quanyi.goods.service.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 代金券状态：
 * SENDED：可用
 * USED：已实扣
 * EXPIRED：已过期
 *
 * @author wangguanhua
 */
@Getter
@AllArgsConstructor
public enum WxCouponStatusEnum {

    /**
     * 可用
     */
    SENDED("可用"),

    /**
     * 已实扣
     */
    USED("已实扣"),

    /**
     * 已过期
     */
    EXPIRED("已过期"),
    ;

    private final String desc;
}
