package cn.com.duiba.quanyi.goods.service.api.remoteservice.car;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.car.CarSerPlatformCodeDto;
import cn.com.duiba.quanyi.goods.service.api.param.car.CarSerPlatformCodeSearchParam;
import java.util.List;

/**
 * 汽车服务-平台服务编码
 * @author kjj mybatis generator 
 * @date 2024-08-11
 */
@AdvancedFeignClient
public interface RemoteCarSerPlatformCodeService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 汽车服务-平台服务编码集合
     */
    List<CarSerPlatformCodeDto> selectPage(CarSerPlatformCodeSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CarSerPlatformCodeSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 汽车服务-平台服务编码
     */
    CarSerPlatformCodeDto selectById(Long id);

    /**
     * 新增
     * @param dto 汽车服务-平台服务编码
     * @return 影响行数
     */
    int insert(CarSerPlatformCodeDto dto);

    /**
     * 更新
     * @param dto 汽车服务-平台服务编码
     * @return 影响行数
     */
    int update(CarSerPlatformCodeDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);

    /**
     * 根据唯一编码查询
     * @param unionCodes 平台服务编码
     * @return 汽车服务-平台服务编码
     */
    List<CarSerPlatformCodeDto> selectByUnionCodes(List<String> unionCodes);

    /**
     * 根据搜索条件查询
     * @param param 搜索条件
     * @return 汽车服务-平台服务编码
     */
    List<CarSerPlatformCodeDto> searchList(CarSerPlatformCodeSearchParam param);
}