package cn.com.duiba.quanyi.goods.service.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.OrderStatusChangeDto;

import java.util.List;
import java.util.Set;

/**
 * @author lizhi
 * @date 2024/4/16 15:36
 */
@AdvancedFeignClient
public interface RemoteOrderStatusChangeService {

    /**
     * 根据订单号批量查询
     *
     * @param orderNos 订单号
     * @return 订单状态变更记录
     */
    List<OrderStatusChangeDto> selectByOrderNos(Set<String> orderNos);

    /**
     * 根据订单号查询
     *
     * @param orderNo 订单号
     * @return 订单状态变更记录
     */
    List<OrderStatusChangeDto> selectByOrderNo(String orderNo);
}
