package cn.com.duiba.quanyi.goods.service.api.dto.cardsecret;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 卡密批次数量变更记录
 *
 * @author yangyukang
 * @date 2025-01-28
 */
@Data
public class CardSecretBatchQtyChangeLogDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 卡密批次ID
     */
    private Long cardSecretBatchId;

    /**
     * 变更类型，1-关联，2-不结算退回，3-结算退回
     */
    private Integer changeType;

    /**
     * 变更数量
     */
    private Long changeQty;

    /**
     * 备注
     */
    private String remark;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;
}

