package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretBatchQtyChangeLogDto;

import java.util.List;

/**
 * 卡密批次数量变更记录远程服务
 *
 * @author yangyukang
 * @date 2025-01-28
 */
@AdvancedFeignClient
public interface RemoteCardSecretBatchQtyChangeLogService {

    /**
     * 根据卡密批次ID查询
     *
     * @param cardSecretBatchId 卡密批次ID
     * @return 卡密批次数量变更记录列表
     */
    List<CardSecretBatchQtyChangeLogDto> selectByCardSecretBatchId(Long cardSecretBatchId);

    /**
     * 根据卡密批次ID集合查询
     *
     * @param cardSecretBatchIds 卡密批次ID集合
     * @return 卡密批次数量变更记录列表
     */
    List<CardSecretBatchQtyChangeLogDto> selectByCardSecretBatchIds(List<Long> cardSecretBatchIds);

    /**
     * 新增
     *
     * @param dto 卡密批次数量变更记录
     * @return 影响行数
     */
    int insert(CardSecretBatchQtyChangeLogDto dto);

    /**
     * 批量新增
     *
     * @param dtos 卡密批次数量变更记录列表
     * @return 影响行数
     */
    int batchInsert(List<CardSecretBatchQtyChangeLogDto> dtos);
}

