package cn.com.duiba.quanyi.goods.service.api.dto.cardsecret;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 卡密关联退回记录
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Data
public class CardSecretAssociationReturnedRecordDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 卡密关联记录Id
     */
    private Long cardSecretAssociationTaskId;

    /**
     * 上传任务ID
     */
    private Long taskId;

    /**
     * 批次号
     */
    private Long cardSecretBatchId;

    /**
     * 操作人ID
     */
    private Long operatorId;

    /**
     * 操作人名称
     */
    private String operatorName;

    /**
     * 发起退回数量
     */
    private Long toReturnQty;

    /**
     * 已退回数量
     */
    private Long returnedQty;

    /**
     * 状态
     * @see cn.com.duiba.quanyi.goods.service.api.enums.cardsecret.ReturnedRecordStatusEnum
     */
    private Integer status;

    /**
     * 回退唯一编码，线上批量退回时存在
     */
    private String uniqueCode;

    /**
     * 是否结算 0-不结算，1-结算
     */
    private Integer isSettled;

}
