/*
 * Decompiled with CFR 0.152.
 */
package enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum ActivityStatusEnum {
    OFFLINE(0, "\u4e0b\u7ebf"),
    ONLINE(1, "\u4e0a\u7ebf");

    private int code;
    private String desc;
    private static final Map<Integer, ActivityStatusEnum> CACHE;

    private ActivityStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityStatusEnum of(int code) {
        return CACHE.get(code);
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(ActivityStatusEnum.values()), ActivityStatusEnum::getCode);
    }
}

