package cn.com.duiba.quwen.fun.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import req.ActivityConfigReq;
import req.ReportFunReq;
import rsp.ActivityConfigRsp;
import rsp.ListActivityRsp;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2018/8/20 15:03
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteFunActivityConfigService {

    /**
     * 根据用户Id和版本号获取活动配置信息
     * @param activityConfigReq
     * @return
     */
    ActivityConfigRsp getConfigByVersion(ActivityConfigReq activityConfigReq);

    /**
     * 根据版本号和用户Id获取列表信息
     * @param activityConfigReq
     * @return
     */
    ListActivityRsp getListFunByVersion(ActivityConfigReq activityConfigReq);

    /**
     * 活动上报
     * @param reportFunReq
     * @return
     */
    boolean repeort(ReportFunReq reportFunReq);

    /**
     * 根据版本号删除可用配置
     * @return
     */
    boolean deleteRedisConfig(Long version);

}
