package enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum ActivityTypeChange {
    /**
     * 限时红包
     */
    TIME_LIMIT_PACKET(1,"timeLimitPacket"),
    /**
     * 邀请好友
     */
    INVITE_DETAIL(2,"inviteDetail"),
    /**
     * 群红包
     */
    GROUP_RED_PACKET(3,"groupRedPacket"),

    /**
     * 点点赚
     */
    CLICK_TWICE_EARN(4,"clickTwiceEarn"),

    /**
     * 签到分享
     */
    SIGN_IN_SHARE(5,"signInShare");

    private Integer code;

    private String  type;


    ActivityTypeChange(Integer code, String type) {
        this.code = code;
        this.type = type;
    }

    public Integer getCode() {
        return code;
    }


    public String getType() {
        return type;
    }


    public static final Map<String, ActivityTypeChange> CACHE = Maps.uniqueIndex(Arrays.asList(ActivityTypeChange
            .values()), ActivityTypeChange::getType);

    public static ActivityTypeChange of(String type) {
        return CACHE.get(type);
    }


}
