package cn.com.duiba.quwen.fun.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import req.ActivityContentReq;
import req.manage.signin.SignInConfigReqDto;
import rsp.ActivityContentDto;
import rsp.manage.signin.ShareSuccessContentRspDto;
import rsp.manage.signin.SignInConfigRspDto;
import rsp.manage.signin.SignInWindowRspDto;

import java.util.List;

/**
 * @Auther: wsz
 * @Date: 2018/8/28 11:54
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteActivityContentService {
    /**
     * 获取活动文案配置（废弃）
     * @param activityContentReq
     * @return
     */
    List<ActivityContentDto> getActivityContent(ActivityContentReq activityContentReq);

    /**
     * 获取签到配置 1.6.0之前
     */
    SignInConfigRspDto getSignInConfig();

    /**
     * 更新签到配置 1.6.0之前
     */
    Boolean updateSignInConfig(SignInConfigReqDto req);

    /**
     * 获取签到弹窗配置  1.6.0
     */
    SignInWindowRspDto getSignInWindowConfig();

    /**
     * 获取签到分享成功配置
     */
    ShareSuccessContentRspDto getSignInShareSuccessContent();
}
