package cn.com.duiba.quwen.fun.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import dto.ArticleMiniProgramMessageDto;
import dto.ArticleMiniProgramMessagePushDto;

import java.util.List;

/**
 * 微信推送消息服务
 */
@AdvancedFeignClient
public interface RemoteArticleMiniProgramMessageService {
    /**
     * 获取微信模板信息表格数据
     */
    List<ArticleMiniProgramMessageDto> getMessageList(Integer offset, Integer max);

    /**
     * 新增或修改微信模板信息
     *
     */
    Boolean insertOrUpdateMessage(ArticleMiniProgramMessageDto dto);


    /**
     * 删除微信模板信息
     *
     */
    Boolean deleteMessage(Long id);



    public List<ArticleMiniProgramMessagePushDto> getMessagePushByPushTime(Long pushTime,Long min,Long max);

    /**
     * 通过id获取微信模板信息
     *
     */
    ArticleMiniProgramMessageDto  getMessageById(Long id);

    /**
     * 获取模板个数
     * @param offset
     * @param max
     * @return
     */
    Integer getCountByParam(Integer offset, Integer max);

    Boolean takePushMessage(List<ArticleMiniProgramMessagePushDto> dtos);
}
