package enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @author wsz
 * @date 2018/10/12 11:12
 * 活动上下线状态
 */
public enum ActivityStatusEnum {
    /**
     * 下线
     */
    OFFLINE(0,"下线"),
    /**
     * 上线
     */
    ONLINE(1,"上线"),
    ;
    private int code;
    private String desc;
    private static final Map<Integer,ActivityStatusEnum> CACHE =  Maps.uniqueIndex(Arrays.asList(values()),ActivityStatusEnum::getCode);

    ActivityStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityStatusEnum of(int code) {
        return CACHE.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
