package cn.com.duiba.quwen.fun.center.api.remoteservice;

import dto.ArticleMiniProgramMessageDto;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

/**
 * 微信推送消息服务
 */
@RestController
public interface RemoteArticleMiniProgramMessageService {
    /**
     * 获取微信模板信息表格数据
     */
    List<ArticleMiniProgramMessageDto> getMessageList(Integer offset, Integer max);

    /**
     * 新增或修改微信模板信息
     *
     */
    Boolean insertOrUpdateMessage(ArticleMiniProgramMessageDto dto);


    /**
     * 删除微信模板信息
     *
     */
    Boolean deleteMessage(Long id);

    /**
     * 通过时间获取微信模板信息
     */
    ArticleMiniProgramMessageDto getMessageByPushTime(Date pushTime);



    /**
     * 通过id获取微信模板信息
     *
     */
    ArticleMiniProgramMessageDto  getMessageById(Long id);
}
