package enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum ActivityReportType {
    /**
     * 曝光
     */
    EXPOSE(1),
    /**
     * 点击
     */
    CLICK(2),
    /**
     * 参与
     */
    PLAY(3),

    /**
     * 通过活动邀请了人
     */
    INVITE(4)

    ;

    private Integer type;

    public Integer getType() {
        return type;
    }

    ActivityReportType(Integer type) {
        this.type = type;
    }


    private static final Map<Integer, ActivityReportType> CACHE = Maps.uniqueIndex(Arrays.asList(ActivityReportType
            .values()), ActivityReportType::getType);

    public static ActivityReportType of(Integer type) {
        return CACHE.get(type);
    }


}
