package enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * Created by wsz on 2018/9/7 15:39.
 */
public enum ActivitySetConfigEnum {
    /**
     * 合集头部配置
     */
    HEADER_CONFIG("headerConfig","合集头部配置"),
    /**
     * 正文分享提示配置
     */
    ARTICLE_SHARE_HINT("articleShareHint","正文分享提示配置"),
    /**
     * 正文分享奖励配置
     */
    ARTICLE_SHARE_REWARD("articleShareReward","正文分享奖励配置"),
    /**
     * 签到弹窗配置
     */
    SIGN_IN_WINDOW("signInWindow","签到弹窗配置"),
    /**
     *签到分享奖励配置
     */
    SIGN_IN_SHARE_REWARD("signInShareReward","签到分享奖励配置"),
    /**
     *签到分享成功文案配置
     */
    SIGN_IN_SHARE_SUCCESS("signInShareSuccess","签到分享成功文案配置"),
    /**
     *签到分享落地页文案配置
     */
    SIGN_IN_LANDPAGE("signInLandPage","签到分享落地页文案配置"),
    /**
     * 1.6.0版本之前签到配置
     */
    SIGN_IN_OLD_CONFIG("signInConfig","1.6.0版本之前签到配置"),
    ;

    private String configName;
    private String desc;
    private static final Map<String, ActivitySetConfigEnum> CACHE = Maps.uniqueIndex(Arrays.asList(ActivitySetConfigEnum
            .values()), ActivitySetConfigEnum::getConfigName);

    ActivitySetConfigEnum(String configName, String desc) {
        this.configName = configName;
        this.desc = desc;
    }

    public static ActivitySetConfigEnum getByConfigName(String name) {
        return CACHE.get(name);
    }

    public String getDesc() {
        return desc;
    }

    public String getConfigName() {
        return configName;
    }

}
