/*
 * Decompiled with CFR 0.152.
 */
package enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum ActivityType {
    TIME_LIMIT_PACKET(1),
    INVITE_DETAIL(2),
    GROUP_RED_PACKET(3),
    CLICK_TWICE_EARN(4),
    SIGN_IN_SHARE(5),
    HOT_ARTICLE(6),
    ARTICLE_SHARE(8),
    WECHAT_HOT_ARTICLE(9);

    private Integer type;
    private static final Map<Integer, ActivityType> CACHE;

    public Integer getType() {
        return this.type;
    }

    private ActivityType(Integer type) {
        this.type = type;
    }

    public static ActivityType of(Integer type) {
        return CACHE.get(type);
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(ActivityType.values()), ActivityType::getType);
    }
}

