package cn.com.duiba.ratelimit.service.api.enums;

import cn.com.duiba.ratelimit.service.api.exception.RatelimitException;

/**
 * 分组子类型
 * Created by guoyanfei .
 * 2018/7/30 .
 */
public enum RatelimitPolicyGroupingSubType {

    USERID("UserId"),
    APPID("AppId");

    private String key;

    RatelimitPolicyGroupingSubType(String key) {
        this.key = key;
    }

    public String key() {
        return key;
    }

    public static RatelimitPolicyGroupingSubType get(String key) {
        for (RatelimitPolicyGroupingSubType item: RatelimitPolicyGroupingSubType.values()) {
            if (item.key().equals(key)) {
                return item;
            }
        }
        throw new RatelimitException("invalid enum value!");
    }
}
