package cn.com.duiba.ratelimit.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.ratelimit.service.api.dto.DomainStatusDTO;

import java.util.List;

/**
 * @author wrj
 * @date 2020/7/7
 */
@AdvancedFeignClient
public interface RemoteDomainService {

    /**
     * 根据域名查询域名状态
     *
     * @param domainList 域名列表
     * @return 域名状态列表
     * @throws BizException 参数不合法或者其他业务异常
     */
    List<DomainStatusDTO> queryDomainStatus(List<String> domainList) throws BizException;

}
