package cn.com.duiba.scrm.center.api.dto.code;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 员工活码-群信息表
 * 2021-7-24 10:30:32
 */
@Data
public class EmpleCodeGroupDto implements Serializable {

    /**
     * 群id(企微)
     */
    private String chatId;

    /**
     * 活码表id
     */
    private Long codeId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 群二维码
     */
    private String groupCode;

    /**
     * 群人数限制
     */
    private Integer groupLimit;

    /**
     * 群名称
     */
    private String groupName;

    /**
     * 序号
     */
    private Integer groupOrder;

    /**
     * 群状态0:未开始，1:进行中，2:人满，3:删除，4:失效
     */
    private Integer groupStatus;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 企微信息表id
     */
    private Long scCorpId;


    public EmpleCodeGroupDto() {

    }

    public EmpleCodeGroupDto(EmpleGroupAddParamDto vo) {
        this.chatId = vo.getChatId();
        this.groupCode = vo.getCodeUrl();
        this.groupLimit = vo.getLimit();
        this.groupName = vo.getName();
        this.groupOrder = vo.getOrder();
        this.id = vo.getId();
    }

    public EmpleGroupAddParamDto convertEmpleGroupAddParamDto() {
        EmpleGroupAddParamDto empleGroupAddParamDto = new EmpleGroupAddParamDto();
        empleGroupAddParamDto.setChatId(this.chatId);
        empleGroupAddParamDto.setCodeUrl(this.groupCode);
        empleGroupAddParamDto.setLimit(this.groupLimit);
        empleGroupAddParamDto.setName(this.groupName);
        empleGroupAddParamDto.setOrder(this.groupOrder);
        empleGroupAddParamDto.setId(this.id);
        empleGroupAddParamDto.setStatus(this.getGroupStatus());
        return empleGroupAddParamDto;
    }

}

