package cn.com.duiba.scrm.center.api.enums;

import com.google.common.collect.Sets;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * 目录-菜单-按钮
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/7/24 15:08
 */
@SuppressWarnings("all")
public enum PermsFlagEnum {
    OVERVIEW(0, "概况", "overview", true, true, true, true),
    OPERATION(0, "引流获客", "operation", true, true, true, false),
    LIVE_QRCODE(1, "渠道活码", "operation/live-qrcode", true, true, true, false),
    CUSTOMER(0, "客户管理", "customer", true, true, true, true),
    USER_MANAGER(1, "客户管理", "customer/userManager", true, true, true, true),
    TAG(1, "客户标签", "customer/tag", true, true, false, true),
    GROUP_MANAGER(1, "客户群管理", "customer/groupManager", true, true, true, true),
    CHURN(1, "流失提醒", "customer/churn", true, true, true, true),
    PROMOTE(0, "促活转化", "promote", true, true, true, false),
    SALUTATION(1, "欢迎语", "promote/salutation", true, true, true, false),
    Masssende(1, "群发消息", "promote/Masssende", true, true, true, false),
    WORDSLIBRARY(1, "话术库", "promote/wordslibrary", true, true, true, false),
    MEDIALIBRARY(1, "素材库", "promote/medialibrary", true, true, true, false),
    PORTRAIT(1, "客户画像", "promote/portrait", true, true, true, true),
    QUICKREPLY(1, "快捷回复", "promote/quickreply", true, true, true, true),
    WORK_TABE(1, "工作台", "promote/workTabe", true, true, true, true),
    MANAGEMENT(0, "企业管理", "management", true, true, true, false),
    STAFFE(1, "员工管理", "management/staffe", true, true, true, true),
    PRIVILEGE(1, "权限管理", "management/privilege", true, true, true, false),
    DELETE(1, "删客户提醒", "management/delete", true, true, true, true),
    ;

    /**
     * （0目录 1菜单 2按钮）
     */
    private final Integer level;
    private final String name;
    private final String permsFlag;

    /**
     * 不同等级的角色是否有权限
     * {@link RoleLevelEnum}
     */
    private final Boolean rootManager;
    private final Boolean manager;
    private final Boolean departmentManager;
    private final Boolean employee;


    PermsFlagEnum(Integer level, String name, String permsFlag, Boolean rootManager, Boolean manager, Boolean departmentManager, Boolean employee) {
        this.level = level;
        this.name = name;
        this.permsFlag = permsFlag;
        this.rootManager = rootManager;
        this.manager = manager;
        this.departmentManager = departmentManager;
        this.employee = employee;
    }

    public Integer getLevel() {
        return level;
    }

    public String getName() {
        return name;
    }

    public String getPermsFlag() {
        return permsFlag;
    }

    public Boolean getRootManager() {
        return rootManager;
    }

    public Boolean getManager() {
        return manager;
    }

    public Boolean getDepartmentManager() {
        return departmentManager;
    }

    public Boolean getEmployee() {
        return employee;
    }

    public static Set<PermsFlagEnum> getPermsFlagEnumByRoleLevel(RoleLevelEnum roleLevelEnum) {
        Set<PermsFlagEnum> permsFlags = Sets.newHashSet();
        if (roleLevelEnum == null) {
            return permsFlags;
        }

        return Arrays.stream(values()).filter(new Predicate<PermsFlagEnum>() {
            @Override
            public boolean test(PermsFlagEnum permsFlagEnum) {
                Boolean result;
                switch (roleLevelEnum) {
                    case ROOT_MANAGER:
                        result = permsFlagEnum.getRootManager();
                        break;
                    case MANAGER:
                        result = permsFlagEnum.getManager();
                        break;
                    case DEPARTMENT_MANAGER:
                        result = permsFlagEnum.getDepartmentManager();
                        break;
                    case EMPLOYEE:
                        result = permsFlagEnum.getEmployee();
                        break;
                    default:
                        result = false;
                        break;
                }
                return result;
            }
        }).collect(Collectors.toSet());
    }

    public static Set<String> getPermsFlagByRoleLevel(RoleLevelEnum roleLevelEnum) {
        Set<String> permsFlags = Sets.newHashSet();
        if (roleLevelEnum == null) {
            return permsFlags;
        }

        return getPermsFlagEnumByRoleLevel(roleLevelEnum).stream().map(PermsFlagEnum::getPermsFlag).collect(Collectors.toSet());
    }
}
