package cn.com.duiba.scrm.center.api.remoteservice.chatgroup;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.chatgroup.ChatGroupMemberDto;
import cn.com.duiba.scrm.center.api.param.chatgroup.ChatGroupMemberQueryParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 企业微信群成员 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 13:53:01
 */
@AdvancedFeignClient
public interface RemoteChatGroupMemberService {
    /**
     * 新增记录
     */
    Boolean save(ChatGroupMemberDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(ChatGroupMemberDto dto);

    /**
     * 根据id获取
     */
    ChatGroupMemberDto getById(Long id);


    /**
     * 获取指定群的群成员信息
     *
     * @param param
     * @return
     */
    ScrmResult<ScrmPageResult<ChatGroupMemberDto>> pageQuery(ChatGroupMemberQueryParam param);

    /**
     * 获取该userid列表在群的所有记录
     * @param userIds
     * @return
     */
    List<ChatGroupMemberDto> getByUserId(Long scCorpId,List<String> userIds);


    /**
     * 获取该用户在群列表中是否存在
     * @param userId
     * @param chatIds
     * @return
     */
    List<ChatGroupMemberDto> getByUserIdAndChatIds(Long scCorpId,String userId,List<String> chatIds);
}
