package cn.com.duiba.scrm.center.api.remoteservice.code;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.code.EmpleCodeAddDto;
import cn.com.duiba.scrm.center.api.dto.code.EmpleCodeDto;
import cn.com.duiba.scrm.center.api.dto.code.EmpleGroupDto;
import cn.com.duiba.scrm.center.api.param.code.ChangeCodeStatusParam;
import cn.com.duiba.scrm.center.api.param.code.RemoteEmpleCodePageQueryParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 员工活码表 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 10:29:21
 */
@AdvancedFeignClient
public interface RemoteEmpleCodeService {
    /**
     * 新增记录
     */
    Boolean save(EmpleCodeDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(EmpleCodeDto dto);

    /**
     * 根据id获取
     */
    EmpleCodeDto getById(Long id);


    /**
     * 根据id列表获取
     */
    List<EmpleCodeDto> getByIdList(List<Long> ids);

    /**
     * 添加个人码（群---有ID更新
     *
     * @param empleGroupDto
     * @return
     */
    ScrmResult<Long> groupAdd(EmpleGroupDto empleGroupDto);


    /**
     * 统计符合条件的数据
     *
     * @param param
     * @return
     */
    ScrmResult<Long> countEmpleCode(RemoteEmpleCodePageQueryParam param);

    /**
     * 查出符合条件的数据
     *
     * @param param
     * @return
     */
    ScrmResult<List<EmpleCodeDto>> pageQuery(RemoteEmpleCodePageQueryParam param);


    /**
     * 修改码状态
     *
     * @param param
     * @return
     */
    ScrmResult<Boolean> changeCodeStatus(ChangeCodeStatusParam param);


    /**
     * 添加员工码---有ID更新
     *
     * @param empleCodeAddDto
     * @return
     */
    ScrmResult<Long> empleAdd(EmpleCodeAddDto empleCodeAddDto);

}
