package cn.com.duiba.scrm.center.api.remoteservice.emple;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.emple.EmpleBizDto;
import cn.com.duiba.scrm.center.api.dto.emple.EmpleWelcomeDto;
import cn.com.duiba.scrm.center.api.param.material.WelcomeMsgPageQueryParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 员工欢迎语表 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 14:42:24
 */
@AdvancedFeignClient
public interface RemoteEmpleWelcomeService {
    /**
     * 新增记录
     */
    Long save(EmpleWelcomeDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(EmpleWelcomeDto dto);

    /**
     * 根据id获取
     */
    EmpleWelcomeDto getById(Long id);

    ScrmResult<ScrmPageResult<EmpleWelcomeDto>> pageQuery(WelcomeMsgPageQueryParam query);

    /**
     * 获取最新可用的一条数据
     * @param ids
     * @return
     */
    ScrmResult<Long> getLastId(List<Long> ids);



}
