package cn.com.duiba.scrm.center.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.tag.TagDto;
import cn.com.duiba.scrm.center.api.param.TagQueryParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 企业微信标签 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 19:23:53
 */
@AdvancedFeignClient
public interface RemoteTagService {
    /**
     * 新增记录
     */
    Boolean save(TagDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(TagDto dto);

    /**
     * 根据id获取
     */
    TagDto getById(Long id);

    List<TagDto> getByIds(List<Long> ids);

    List<TagDto> getByTagIds(Long scCorpId, List<String> tagIds);


    ScrmResult<ScrmPageResult<TagDto>> queryPage(TagQueryParam queryParam);
}
